package com.live.xmutils;

import com.alibaba.fastjson.JSONObject;
import com.live.cases.largeClassLive.LargeClassLiveTools;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetLiveCourseData extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        dataApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_createLargeClassLive") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    @Test
    public String getLiveCourseData() {
        LargeClassLiveTools getLargeClassLiveTools = new LargeClassLiveTools();
        JSONObject largeClassLive = getLargeClassLiveTools.buildCreateLargeClassLiveParam();

        dataApi.doRequest(RequestType.JSON, params, largeClassLive.toString(), headers);
        JSONObject jsonBody = dataApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);
        String liveCourseId=jsonBody.getString("result");
        System.out.println("liveCourseId = "+liveCourseId);

        Assert.assertEquals(jsonBody.getString("success"),"true");
        Assert.assertEquals(StringUtils.isNotBlank(jsonBody.getString("result")),true);

        return liveCourseId;

    }


}
