package com.live.xmutils;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.TimeUtils;
import com.live.utils.XMBaseTest;
import com.mysql.jdbc.TimeUtil;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GetOnlyOneCourseData extends XMBaseTest {

    public JSONObject getOnlyOneCourseList() {

        dataApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getOnlyOneClassLiveList") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();


        Map bodyMap = new HashMap();
        bodyMap.put("current", 1);
        bodyMap.put("instId", "1235115978015883266");
        bodyMap.put("size", 10);
//        bodyMap.put("courseState","EXPIRED");
        String bodydata = JSONObject.toJSONString(bodyMap);

//        dataApi.doRequest(RequestType.JSON, params, bodydata, dataheadrs);
        dataApi.doRequest(RequestType.JSON, params, bodydata, headers);
        System.out.println("dataApi  ="+dataApi);
        JSONObject liveCourseList=dataApi.getBodyInJSON();

        return liveCourseList;
    }

    public JSONObject creatOnlyOneCourse() throws InterruptedException {
        dataApi.setApiModule(ApiModele.CloudClass_apollo)
                .setApiName("API_createCourse")
                .setLoginUser("zhangy-b")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        dataApi.doRequest(RequestType.JSON, params, buildCreateLargeClassLiveParam().toJSONString(), headers);
//        dataApi.doRequest(RequestType.JSON, params, buildCreateLargeClassLiveParam().toJSONString(), dataheadrs);
        System.out.println("dataApi  ="+dataApi);

        TimeUnit.SECONDS.sleep(3);

        JSONObject liveCourse=dataApi.getBodyInJSON();

        return liveCourse;
    }

    //组装乐器陪练直播新增的数据
    public JSONObject buildCreateLargeClassLiveParam() {
        JSONObject onlyOneClassLive = new JSONObject();
        onlyOneClassLive.put("courseName", RandomStringUtil.randomNumber(14, "course_"));
        onlyOneClassLive.put("teacherId",dataApi.getLoginInfo().getTid());
        onlyOneClassLive.put("startTime",System.currentTimeMillis() + 60 * 1000);
        onlyOneClassLive.put("endTime",System.currentTimeMillis() + 60 * 60 * 1000);
        onlyOneClassLive.put("needRecord","YES");
        onlyOneClassLive.put("liveType","SMALL_CLASS_ONLY_ONE");
        onlyOneClassLive.put("consumeHourNum",1);
        onlyOneClassLive.put("consumeClassTime","1");
        onlyOneClassLive.put("autoSendReport","AUTO");
        onlyOneClassLive.put("consumeClassTime","30");
        onlyOneClassLive.put("consumeClassTime","30");
        onlyOneClassLive.put("whetherRecord","YES");

        return onlyOneClassLive;
    }


}
