package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

import static io.restassured.RestAssured.given;
import static org.hamcrest.Matchers.equalTo;

/**
 * @author NHX-->zym
 * @Function B端课表管理-课次详情 按关系Id获取关系
 * @Date 2020/11/19 15:01
 */
public class TestGetRelationByRelationId_B extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块
                .setApiName("API_getRelationByRelationId") // API 名称
                .setLoginUser("zhangYuM_b")         // http 接口，测试账号
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）


        dal.setCase_owner("zym")
                .setCase_name("B端课表管理-课次详情 按关系Id获取关系：" + Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);

        super.beforeTest();
    }

    @Test(description = "B端课表管理-课次详情 按关系Id获取关系")
    public void testGetRelationByRelationId(){


        Map<String,Object> bodyMap = new HashMap<>();
        bodyMap.put("relationId","1275721048882462728");
        bodyMap.put("relationType","SCHEDULE");
        bodyMap.put("instId","1235818358426509313");


        JSONObject jsonBody = new JSONObject(bodyMap);
        String data = jsonBody.toJSONString();

        System.out.println("请求参数==========="+data);
//
//        xmAppApi.doRequest(RequestType.JSON, params, data, headers);
//        JSONObject jsonResponseBody = xmAppApi.getBodyInJSON();
//        Assert.assertEquals(jsonResponseBody.getString("success"), "true", "操作成功!");
        given()
                .header("Content-Type", "application/json; charset=UTF-8")
                .body(data)
                .when()
                .post(xmAppApi.getUrl())
                .then().log().all()
                .body("success", equalTo(true));


    }

}
