package com.live.cases.liveClientT.musicPlay;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangying
 * @date 2021/2/25 17:42
 */
public class TestGetClassReport extends XMBaseTest {
    @BeforeMethod
    public void beforeTest()  {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getClassReport") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 测试乐器陪练课查看课堂报告
     */
    @Test
    public void testGetClassReport() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("courseId","1356196461296828418");

        System.out.println("jsonObject == "+jsonObject);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertNotEquals(0, jsonBody.getJSONObject("result").size());
    }
}
