package com.live.cases.liveAssets;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/2/23 6:08 下午
 */
public class TestRechargeProtocol extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_rechargeProtocol") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 互动班课-账户管理-服务协议签订记录
     */
    @Test
    public void testRechargeProtocol() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId",xmAppApi.getLoginInfo().getInstId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }
}
