package com.live.cases.liveClientT.musicPlay;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/2/25 17:59
 */
public class TestGetLiveCourseRecordInfos extends XMBaseTest {
    @BeforeMethod
    public void beforeTest()  {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getLiveCourseRecordInfos") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 测试乐器陪练课-每课学堂APP查看回放
     */
    @Test
    public void testGetClassReport() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId","1356196461296828418");   //固定课程记录

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertNotEquals(0, jsonBody.getJSONObject("result").size());
    }
}
