package com.live.cases.apollo;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.xmutils.GetLiveCourseData;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;


/**
 * Created by zhangying on  2020/11/27
 */

public class TestInitXmLive extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("api_initXmLive") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 测试初始化直播间信息
     */
    @Test
    public void testInitXmLive() {
        GetLiveCourseData getLiveCourseData=new GetLiveCourseData();
        JSONObject largeClassCourse=getLiveCourseData.getLargeClassLiveList();

        JSONObject liveCourse=largeClassCourse.getJSONObject("result").getJSONArray("records").getJSONObject(0);
        String liveCourseId= (String) liveCourse.get("liveCourseId");
        if (liveCourseId==null){
            largeClassCourse=getLiveCourseData.createLargeClassLive();
            liveCourseId= (String) largeClassCourse.get("liveCourseId");
        }
        System.out.println("liveCourseId ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }


}
