package com.live.cases.liveClientT.cloundClass;


import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetDayTime;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

import static io.restassured.RestAssured.given;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by zhangying on  2020/11/16
 */

public class TestGetCourseList extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("api_getCourseList") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
                dal.setCase_owner("zhangying")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    /**
     * 测试直播客户端查询课表
     */
    @Test
    public void testGetCourseList() {
        GetDayTime getDayTime = new GetDayTime();
        long zeroTime = getDayTime.getDayZeroTime();

        Map bodyMap = new HashMap();
        bodyMap.put("adminId", xmAppApi.getLoginInfo().getAid());
        bodyMap.put("channel", "XIAOMAI");
        bodyMap.put("endTime",zeroTime+24*60*60*1000-1000);
        bodyMap.put("instId", xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("startTime", zeroTime);
        bodyMap.put("teacherId",xmAppApi.getLoginInfo().getTid());


        String bodydata = JSONObject.toJSONString(bodyMap);

        // 接口请求 返回responseBody
        given()
                .header("Content-Type", "application/json")
                .queryParams(params)
                .headers(headers)
                .body(bodydata)
                .when()
                .post(xmAppApi.getUrl())
                .then().log().all()
                .body("success", equalTo(true));
    }
}

