package com.live.cases.seriesCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetSeriesCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/24 10:06 上午
 */
public class TestEditSeries extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_editSeries") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    @Test
    public void testEditSeries(){

        GetSeriesCourseData getSeriesCourseData = new GetSeriesCourseData();
        String id = getSeriesCourseData.createSeriesCourse();

        String seriesName = RandomStringUtil.randomNumber(20,"series_edit");


        Map Media = new HashMap();
        Media.put("mediaContent","这是系列课简介<p><br></p>");
        Media.put("mediaType","TEXT");
        Media.put("contentType","INTRO");
        Media.put("mediaContentLength",7);

        List scheduleMedia = new ArrayList();
        scheduleMedia.add(Media);

        Map bodyMap = new HashMap();
        bodyMap.put("id",id);
        bodyMap.put("instId",xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("teacherId",xmAppApi.getLoginInfo().getTid());
        bodyMap.put("coverId","1362677307414863873");
        bodyMap.put("joinType","ALL");
        bodyMap.put("smsCheck","VALID");
        bodyMap.put("showType","LOCK");
        bodyMap.put("enableJoinStuIds",new ArrayList<>());
        bodyMap.put("joinStudentIds",new ArrayList<>());
        bodyMap.put("seriesName",seriesName);
        bodyMap.put("scheduleMedia",scheduleMedia);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody = xmAppApi.getBodyInJSON();

        JSONObject seriesPage = getSeriesCourseData.getSeriesPage();

        Assert.assertEquals(id,seriesPage.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id"));




    }
}
