package com.live.cases.seriesCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetSeriesCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/23 9:52 上午
 */
public class TestSeriesDetail extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_seriesDetail") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    @Test
    public void testSeriesDetail(){

        GetSeriesCourseData getSeriesCourseData = new GetSeriesCourseData();
        String seriesId = getSeriesCourseData.createSeriesCourse();

        Map bodyMap = new HashMap();
        bodyMap.put("seriesId",seriesId);
        bodyMap.put("instId",xmAppApi.getLoginInfo().getInstId());

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody0 = xmAppApi.getBodyInJSON();
        String id = jsonBody0.getJSONObject("result").getString("id");

        Assert.assertEquals(seriesId,id);



    }

}
