package com.live.xmutils;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/19 5:15 下午
 */
public class GetSeriesCourseData extends XMBaseTest {

    public JSONObject getSeriesPage(){

         dataApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_seriesPage") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();

        Map bodyMap = new HashMap();

        bodyMap.put("teacherId","");
        bodyMap.put("current",1);
        bodyMap.put("instId",dataApi.getLoginInfo().getInstId());
        bodyMap.put("size",10);
        bodyMap.put("createTimeBegin","");
        bodyMap.put("createTimeEnd","");
        bodyMap.put("seriesName","");


        System.out.println("bodyMap = "+bodyMap);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();
        System.out.println("bodyData  = "+bodyData);

        dataApi.doRequest(RequestType.JSON, params,bodyData, headers);
        System.out.println(dataApi);

        JSONObject seriesPage = dataApi.getBodyInJSON();

        return seriesPage;

    }


    public String createSeriesCourse(){

        dataApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_createSeries") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();

        String seriesName = RandomStringUtil.randomNumber(20,"series_");


        Map mediaMap = new HashMap();
        mediaMap.put("mediaType","TEXT");
        mediaMap.put("mediaContent","这是系列课简介");
        mediaMap.put("key","sCJFBRyjFTzxcXCR");
        mediaMap.put("mediaContentLength",7);

        List scheduleMedia = new ArrayList();
        scheduleMedia.add(mediaMap);

        List enableJoinStuIds = new ArrayList();



        List joinStudentIds = new ArrayList();


        Map bodyMap = new HashMap();
        bodyMap.put("seriesName",seriesName);
        bodyMap.put("instId", dataApi.getLoginInfo().getInstId());
        bodyMap.put("teacherId",dataApi.getLoginInfo().getTid());
        bodyMap.put("coverId","1362677307414863873");
        bodyMap.put("joinType","ALL");
        bodyMap.put("smsCheck","VALID");
        bodyMap.put("showType","LOCK");
        bodyMap.put("scheduleMedia",scheduleMedia);
        bodyMap.put("joinStudentIds",joinStudentIds);
        bodyMap.put("enableJoinStuIds",enableJoinStuIds);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        dataApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(dataApi);
        com.alibaba.fastjson.JSONObject jsonBody = dataApi.getBodyInJSON();

        String seriesId = jsonBody.getString("result");

        return seriesId;

    }

    //一个系列课里有一个视频课
    public Map editSeriesSchedule(){


        GetVideoClassData getVideoClassData = new GetVideoClassData();
        String scheduleId = getVideoClassData.VideoClassData().getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        String seriesId = createSeriesCourse();

        dataApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_editSeriesSchedule") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();



        List scheduleIds = new ArrayList();
        scheduleIds.add(scheduleId);

        Map bodyMap = new HashMap();
        bodyMap.put("seriesId",seriesId);
        bodyMap.put("scheduleIds",scheduleIds);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        dataApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(dataApi);
        com.alibaba.fastjson.JSONObject jsonBody = dataApi.getBodyInJSON();

        Map dataMap = new HashMap();
        dataMap.put("seriesId",seriesId);
        dataMap.put("scheduleId",scheduleId);
        return dataMap;


    }

    public Map editSeriesSchedule2(){

//取出视频课列表前两个ID
        GetVideoClassData getVideoClassData = new GetVideoClassData();
        String scheduleId0 = getVideoClassData.VideoClassData().getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        String scheduleId1 = getVideoClassData.VideoClassData().getJSONObject("result").getJSONArray("records").getJSONObject(1).getString("id");


        String seriesId = createSeriesCourse();

        dataApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_editSeriesSchedule") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();


        List scheduleIds = new ArrayList();
        scheduleIds.add(scheduleId0);
        scheduleIds.add(scheduleId1);

        Map bodyMap = new HashMap();
        bodyMap.put("seriesId",seriesId);
        bodyMap.put("scheduleIds",scheduleIds);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        dataApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(dataApi);
        com.alibaba.fastjson.JSONObject jsonBody = dataApi.getBodyInJSON();

        Map dataMap = new HashMap();
        dataMap.put("seriesId",seriesId);
        dataMap.put("scheduleIds",scheduleIds);
        return dataMap;


    }

    public JSONObject getSeriesScheduleIdList(){

        Map data = editSeriesSchedule2();
        String seriesId = data.get("seriesId").toString();


        dataApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getSeriesScheduleIdList") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();

        Map bodyMap = new HashMap();
        bodyMap.put("seriesId",seriesId);
        bodyMap.put("instId",dataApi.getLoginInfo().getInstId());

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        dataApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(dataApi);
        com.alibaba.fastjson.JSONObject jsonBody = dataApi.getBodyInJSON();

        jsonBody.put("seriesId",seriesId);

        return jsonBody;

    }
}
