/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomai.utils;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatatUtils {
    private static final String JAVAP = "java.";
    private static final String JAVADATESTR = "java.util.Date";

    public static Map<String, Object> objectToMap(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        System.out.println(clazz);
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            map.put(fieldName, value);
        }
        return map;
    }

    public static Map<String, String> objectToMapString(String timeFormatStr, Object obj, String ... excludeFields) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (excludeFields.length != 0) {
            List<String> list = Arrays.asList(excludeFields);
            try {
                DatatUtils.objectTransfer(timeFormatStr, obj, map, list);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                DatatUtils.objectTransfer(timeFormatStr, obj, map, null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static Map<String, String> objectTransfer(String timeFormatStr, Object obj, Map<String, String> map, List<String> excludeFields) throws IllegalAccessException {
        boolean isExclude = false;
        String formatStr = "YYYY-MM-dd HH:mm:ss";
        if (timeFormatStr != null && !timeFormatStr.isEmpty()) {
            formatStr = timeFormatStr;
        }
        if (excludeFields != null) {
            isExclude = true;
        }
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            String fieldName = clazz.getSimpleName() + "." + field.getName();
            if (isExclude && excludeFields.contains(fieldName)) continue;
            field.setAccessible(true);
            Object value = field.get(obj);
            Class<?> valueClass = value.getClass();
            if (valueClass.isPrimitive()) {
                map.put(fieldName, value.toString());
                continue;
            }
            if (valueClass.getName().contains(JAVAP)) {
                if (valueClass.getName().equals(JAVADATESTR)) {
                    SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                    Date date = (Date)value;
                    String dataStr = sdf.format(date);
                    map.put(fieldName, dataStr);
                    continue;
                }
                map.put(fieldName, value.toString());
                continue;
            }
            DatatUtils.objectTransfer(timeFormatStr, value, map, excludeFields);
        }
        return map;
    }
}

