package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author NHX
 * @Function C端获取课表文件计数
 * @Date 2020/11/19 15:01
 */
public class TestGetScheduleFileCount_C extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_customerLive) // API 所属模块
                .setApiName("API_getScheduleFileCount") // API 名称
                .setLoginUser("NHX_c")         // http 接口，测试账号
                .setTerminal(Terminal.C);             // 所属端位（B端，C端，M端等, 必传）


        dal.setCase_owner("NHX")
                .setCase_name("C端获取课表文件计数：" + Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);

        super.beforeTest();
    }

    @Test(description = "C端获取课表文件计数")
    public void testLoadStudentListAPI(){

        List list = new ArrayList();
        list.add("1145613399253643266");

        Map<String,Object> bodyMap = new HashMap<>();
        bodyMap.put("scheduleIds",list);

        JSONObject jsonBody = new JSONObject();
        String data = jsonBody.toJSONString();

        System.out.println("请求参数==========="+data);

        xmAppApi.doRequest(RequestType.JSON, params, data, headers);
        JSONObject jsonResponseBody = xmAppApi.getBodyInJSON();
        Assert.assertEquals(jsonResponseBody.getString("success"), "true", "操作成功!");


    }

}
