package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author NHX
 * @Function  使用可用帐户获取学生名单
 * @Date 2020/11/13 17:34
 */
public class TestGetStudentListWithUseAbleAccount extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块
                .setApiName("API_getStudentListWithUseAbleAccount") // API 名称
               // .setEnv(Env.PROD)            // 运行环境
                .setLoginUser("NHX_b")         // http 接口，测试账号
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        dal.setCase_owner("NHX")
                .setCase_name("使用可用帐户获取学生名单：" + Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        System.out.println(dal);
        super.beforeTest();
    }

    @Test(description = "使用可用帐户获取学生名单")
    public void testLoadStudentListAPI(){
        Map<String,Object> bodyMap = new HashMap<>();
        bodyMap.put("size",10);
        bodyMap.put("current",1);

        JSONObject jsonBody = new JSONObject(bodyMap);
        String data = jsonBody.toJSONString();

        System.out.println("请求参数==========="+jsonBody.toString());

        xmAppApi.doRequest(RequestType.JSON, params, data, headers);
        JSONObject jsonResponseBody = xmAppApi.getBodyInJSON();
        Assert.assertEquals(jsonResponseBody.getString("success"), "true", "true");
    }

}
