package com.live.xmutils.baseapi;


import com.xiaomai.client.BaseTest;
import com.live.enums.ApiModele;
import com.live.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;


/**
 * Created by zhangying on  2020/11/19
 */

public abstract class CloundClassApiBaseTest extends XMBaseTest {

//    public static String instId_C = userInfoParam.getString("instId");
//    public static String studentId_C = userInfoParam.getString("studentId");
//    static String classId_C = userInfoParam.getString("classId");

    @BeforeClass
    public static void beforeClass() {
        BaseTest.beforeClass();
    }

    @AfterClass
    public static void afterClass() {
        BaseTest.afterClass();
    }

    @BeforeMethod
    public void beforeTest() {
        //设置测试信息：env、Apimodule、Apiname、接口账号信息、端口位
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块
                .setApiName(getApiName()) // API 名称
//                .setEnv(GRAY)            // 运行环境
                .setLoginUser("zhangyLive-b.gray")         // 测试账号
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        dal.setCase_owner("zhangying")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
//        // 预置登录信息

        super.beforeTest();
    }

    protected abstract String getApiName();

    @AfterMethod
    public void afterTest(ITestResult result) {
        super.afterMethod(result);
    }



}