package com.live.cases.fileManage.commonFolder;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/03
 */

public  class TestSameNameFile extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_sameNameFile") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 资料云盘-同名文件查询
     */
    @Test
    public void testSameNameFile() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("disk","COMMON");
        jsonObject.put("folderType","FOLDER");
        jsonObject.put("instId","1235115978015883266");
        jsonObject.put("name","zy自动化测试文件夹1");
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        Assert.assertEquals(jsonBody.getJSONObject("result").getString("folderName"),"zy自动化测试文件夹1");
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

}
