package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/3/12 18:08
 */
public class TestCreateBigInteractionCourse extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_createBigLiveCourse") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    @Test
    public void testCreateBigInteractionCourse() {

        JSONObject largeInteractionClassLive = new JSONObject();
        largeInteractionClassLive.put("courseName", RandomStringUtil.randomNumber(14, "live_course_"));
        largeInteractionClassLive.put("teacherId","1235115979473997826");
        largeInteractionClassLive.put("startTime",System.currentTimeMillis() + 60 * 1000);
        largeInteractionClassLive.put("endTime",System.currentTimeMillis() + 30 * 60 * 1000);
        largeInteractionClassLive.put("needRecord","YES");
        largeInteractionClassLive.put("liveType","LARGE_CLASS_INTERACTION");
        largeInteractionClassLive.put("consumeHourNum",1);
        largeInteractionClassLive.put("consumeClassTime","1");
        largeInteractionClassLive.put("podium","12");

        xmAppApi.doRequest(RequestType.JSON, params, largeInteractionClassLive.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        String courseId =jsonBody.getString("result");

        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getCourseData = getLiveCourseData.getInteractionClassLiveList();
        System.out.println("getCourseData"+getCourseData);

        String courseId1 = getCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals(courseId, courseId1);

    }

}
