package com.live.cases.liveClientT.cloundClass;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import static org.testng.Assert.assertTrue;


/**
 * title获取直播器启动协议
 * by张雨朦
 */

public class TestCourseLaunch extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo)
                .setApiName("API_courseLaunch")
                .setLoginUser("zhangyumeng_huantuo")    //欢拓的账号测试
                .setTerminal(Terminal.B);
        super.beforeTest();
    }

    @Test
    public void courseLaunch(){
        String protocol="huantuo://start#eyJiaWQiOiI0MzU5NjUiLCJldCI6MTYxNzQ0NTY5NSwiZXh0Ijp7ImNvdXJzZV9pZCI6MTQ0MjU3OX0sInNpZ24iOiI1ZTE5Zjk3YzRkZDlmNTk3YTJiNTk4NmI0OWY2OWRkZiJ9";

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId","1333692400423833602");

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject responseRes = xmAppApi.getBodyInJSON();
        System.out.println("responseRes  =="+responseRes);

//        Assert.assertTrue(responseRes.getJSONObject("result").values().contains("protocol"));
        Assert.assertEquals("true", responseRes.getString("success"));
        Assert.assertEquals("操作成功!", responseRes.getString("message"));
        Assert.assertEquals("200", responseRes.getString("code"));
//        Assert.assertEquals( responseRes.getJSONObject("result").getString("protocol"),protocol);


    }

}
