package com.live.xmutils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.utils.TimeSetting;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;

import java.util.ArrayList;

/**
 * 创建直播课，返回课程id
 * by 张雨朦
 */

public class GetLiveCourseId extends XMBaseTest {

    /**
     * 获取机构员工列表
     * @return teacherId
     */
    public String createCourse(){
        dataApi.setApiModule(ApiModele.CloudClass_B)
                .setApiName("API_getInstAdminExdOnePage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject obj = new JSONObject();
        obj.put("state","VALID");

        dataApi.doRequest(com.live.enums.RequestType.JSON,dataparams,obj.toJSONString(),dataheadrs).assetsSuccess(true);

        String teacherID = dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONObject("instAdmin").getString("teacherId");

        /**
         *请求创建大班直播课接口
         */
        dataApi.setApiName("API_createBigLiveCourse");
        super.beforeDataRequest();     //重置请求接口，否则会请求到上面API_getInstAdminExdOnePage

        JSONObject jsonObject = new JSONObject();
        TimeSetting startTime = new TimeSetting();
        jsonObject.put("startTime", startTime.startTime());
        TimeSetting endTime = new TimeSetting();
        jsonObject.put("endTime", endTime.endTime());
        jsonObject.put("teacherId",teacherID);
        jsonObject.put("liveType", "LARGE_CLASS_LIVE");
        jsonObject.put("adminIds", new ArrayList<>());
        jsonObject.put("courseName", "自动化创建直播课");
        jsonObject.put("studentIds", new ArrayList<>());
        jsonObject.put("consumeStudentIds", new JSONArray());
        jsonObject.put("liveCourseMediaRequests", new JSONArray());
        jsonObject.put("needRecord", "YES");
        jsonObject.put("applyMode", "ANYONE");

        dataApi.doRequest(com.live.enums.RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);

        JSONObject responseRes = dataApi.getBodyInJSON();
        String liveCourseID = responseRes.getString("result");  //获取课程id
        return liveCourseID;   //返回课程id

    }


}
