package com.live.xmutils.baseapi;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.BaseTest;
import com.live.enums.ApiModele;
import com.live.enums.Terminal;
import org.springframework.test.context.ContextConfiguration;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

/**
 * Created by zhangying on  2020/11/17
 */

@ContextConfiguration(locations = {"classpath:/spring-core.xml"})
public abstract class ApiBaseTestFile extends BaseTest {

    @BeforeClass
    public static void beforeClass() {
        BaseTest.beforeClass();
    }

    @AfterClass
    public static void afterClass() {
        BaseTest.afterClass();
    }

    @BeforeMethod
    public void beforeTest() {
        //设置测试信息：env、Apimodule、Apiname、接口账号信息、端口位
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块
                .setApiName(getApiName()) // API 名称
//                .setEnv("prod")            // 运行环境
                .setLoginUser("zhangy-b")         // 测试账号
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）


        super.beforeTest();
    }

    @AfterMethod
    public void afterTest(ITestResult result) {
        super.afterMethod(result);
    }


    /**
     *
     * @return
     */
    protected abstract String getApiName();


    protected static JSONObject doRequest(String data){


        okHttpClient.doPostRequest(url,data,headers);
        JSONObject jsonBody = okHttpClient.getBodyInJSON();

        return jsonBody;
    }

}
