package com.live.cases.liveClientT.cloundClass;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangying
 * @date 2021/3/4 17:29
 */
public class TestRelationLessonFile extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_relationLessonFile") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试直播间上传课件
     */
    @Test
    public void testRelationLessonFile() throws InterruptedException {
        GetLiveCourseData getLiveCourseData=new GetLiveCourseData();
        JSONObject largeCourse=getLiveCourseData.createLargeClassLive();

        String liveCourseId=largeCourse.getString("result");
        System.out.println("liveCourseId ="+liveCourseId);

        List addFolderIds = new ArrayList();
        addFolderIds.add("1367380611227922433");
        System.out.println("addFolderIds = "+addFolderIds);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAid());
        jsonObject.put("operatorType",2);
        jsonObject.put("addFolderIds",addFolderIds);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody =="+jsonBody);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
//        Assert.assertNotEquals(null, jsonBody.getJSONObject("result"));
    }
}
