package com.live.cases.liveClientT.cloundClass;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangying
 * @date 2021/3/4 17:29
 */
public class TestTencentStartRecord extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_tencentStartRecord") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试直播间开启录制
     */
    @Test
    public void testTencentStartRecord() throws InterruptedException {
        GetLiveCourseData getLiveCourseData=new GetLiveCourseData();
        JSONObject largeCourse=getLiveCourseData.createLargeClassLive();

        String liveCourseId=largeCourse.getString("result");
        System.out.println("liveCourseId ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody =="+jsonBody);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals("200", jsonBody.getString("code"));
    }
}
