package com.live.cases.apollo;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetOnlyOneClassLiveListData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2021/1/30
 */

public class TestCreateOnlyOneClassLive extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_createCourse") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试创建乐器陪练课
     */
    @Test
    public void testGetOnlyOneClassLiveList() {

        JSONObject onlyOneClassLive = new JSONObject();
        String courseName = RandomStringUtil.randomNumber(14, "live_course_");
        onlyOneClassLive.put("courseName",courseName );
        onlyOneClassLive.put("teacherId",xmAppApi.getLoginInfo().getTid());
        onlyOneClassLive.put("startTime",System.currentTimeMillis() + 60 * 1000);
        onlyOneClassLive.put("endTime",System.currentTimeMillis() + 60 * 60 * 1000);
        onlyOneClassLive.put("needRecord","YES");
        onlyOneClassLive.put("liveType","SMALL_CLASS_ONLY_ONE");
        onlyOneClassLive.put("consumeHourNum",1);
        onlyOneClassLive.put("consumeClassTime","1");
        onlyOneClassLive.put("autoSendReport","AUTO");
        onlyOneClassLive.put("consumeClassTime","30");
        onlyOneClassLive.put("consumeClassTime","30");
        onlyOneClassLive.put("whetherRecord","YES");

        xmAppApi.doRequest(RequestType.JSON, params, onlyOneClassLive.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        GetOnlyOneClassLiveListData getOnlyOneClassLiveListData = new GetOnlyOneClassLiveListData();
        JSONObject liveList = getOnlyOneClassLiveListData.getOnlyOneClassLiveList() ;
        JSONObject liveCourse = liveList.getJSONObject("result").getJSONArray("records").getJSONObject(0);
        String courseName1 = (String) liveCourse.get("courseName");
        System.out.println("courseName ="+courseName);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals(courseName, courseName1);
    }

}
