package com.live.cases.fileManage;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

import static io.restassured.RestAssured.given;
import static org.hamcrest.Matchers.equalTo;

/**
 * @author NHX-->zym
 * @Function B端查询大班直播列表
 * @Date 2020/11/19 15:01
 */
public class TestGetLargeClassLiveList_B extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块
                .setApiName("API_getLargeClassLiveList") // API 名称
                .setLoginUser("zhangYuM_b")         // http 接口，测试账号
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        dal.setCase_owner("zym")
                .setCase_name("B端查询大班直播列表：" + Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);

        super.beforeTest();
    }

    @Test(description = "B端查询大班直播列表")
    public void testGetLargeClassLiveList(){

        Map<String,Object> bodyMap = new HashMap<>();
        bodyMap.put("current",1);
        bodyMap.put("size",1);
        bodyMap.put("instId","1009415524133634144");


        JSONObject jsonBody = new JSONObject(bodyMap);
        String data = jsonBody.toJSONString();

        System.out.println("请求参数==========="+data);
        //headers.put("userId","1145612151844098049");
//
//        xmAppApi.doRequest(RequestType.JSON, params, data, headers);
//        JSONObject jsonResponseBody = xmAppApi.getBodyInJSON();
//        Assert.assertEquals(jsonResponseBody.getString("success"), "true", "操作成功!");
        given()
                .header("Content-Type", "application/json; charset=UTF-8")
                .body(data)
                .when()
                .post(xmAppApi.getUrl())
                .then().log().all()
                .body("success", equalTo(true));


    }

}
