package com.live.cases.videoCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetVideoClassData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/19 11:34 上午
 */
public class TestRemoveLessonSchedule extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Video) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_removeLessonSchedule") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }



    @Test
    public void testRemoveLessonSchedule(){

        GetVideoClassData getVideoClassData = new GetVideoClassData();

        JSONObject jsonBody  = getVideoClassData.VideoClassData();
        String scheduleId = jsonBody.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        String strTotal = jsonBody.getJSONObject("result").getString("total");
        int total = Integer.parseInt(strTotal);

        Map bodyMap = new HashMap();
        bodyMap.put("scheduleId",scheduleId);

        org.json.JSONObject jsonObject = new org.json.JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody0 = xmAppApi.getBodyInJSON();

        JSONObject jsonBody1  = getVideoClassData.VideoClassData();
        String strTotal0 = jsonBody1.getJSONObject("result").getString("total");
        int total0 = Integer.parseInt(strTotal0);
        Assert.assertEquals(total,total0+1);

    }



}
