package com.live.cases.fileManage.commonFolder;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetFolderData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/2/23 7:26 下午
 */
public class TestUpdateFileUserAuthority extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_updateFileUserAuthority") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 测试资料云盘-公共文件夹成员管理，修改权限，可查看/下载——>可编辑
     */
    @Test
    public void testUpdateFileUserAuthority() throws InterruptedException {
        GetFolderData commonFolderList = new GetFolderData();
        JSONObject folderList = commonFolderList.getCommonFolderList();
        String folderId = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        JSONObject userAuthority = commonFolderList.getFileUserAuthority(folderId);
        String updateId = userAuthority.getJSONArray("result").getJSONObject(0).getString("userId");//操作账户的userId
        String userId = userAuthority.getJSONArray("result").getJSONObject(1).getString("userId");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId", xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("id", folderId);
        jsonObject.put("userId", userId);
        jsonObject.put("updateId", updateId);
        jsonObject.put("rights", "EDIT");


        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        JSONObject userAuthority1 = commonFolderList.getFileUserAuthority(folderId);
        String userRights = userAuthority1.getJSONArray("result").getJSONObject(1).getString("rights");

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("EDIT", userRights);

    }

    /**
     * 测试资料云盘-公共文件夹添加员工，可编辑——>可查看/下载
     */
    @Test
    public void testUpdateFileUserAuthority1() throws InterruptedException {
        GetFolderData commonFolderList = new GetFolderData();
        JSONObject folderList = commonFolderList.getCommonFolderList();
        String folderId = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        JSONObject userAuthority = commonFolderList.getFileUserAuthority(folderId);
        String updateId = userAuthority.getJSONArray("result").getJSONObject(0).getString("userId");//操作账户的userId
        String userId = userAuthority.getJSONArray("result").getJSONObject(1).getString("userId");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId", xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("id", folderId);
        jsonObject.put("userId", userId);
        jsonObject.put("updateId", updateId);
        jsonObject.put("rights", "LOOK_DOWNLOAD");


        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);

        JSONObject userAuthority1 = commonFolderList.getFileUserAuthority(folderId);
        String userRights = userAuthority1.getJSONArray("result").getJSONObject(1).getString("rights");

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("LOOK_DOWNLOAD", userRights);

    }

    /**
     * 测试资料云盘-公共文件夹添加员工，操作账户无操作权限
     */
    @Test
    public void testUpdateFileUserAuthority2() throws InterruptedException {
        GetFolderData commonFolderList = new GetFolderData();
        JSONObject folderList = commonFolderList.getCommonFolderList();
        String folderId = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        JSONObject userAuthority = commonFolderList.getFileUserAuthority(folderId);
        String userId = userAuthority.getJSONArray("result").getJSONObject(1).getString("userId");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId", xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("id", folderId);
        jsonObject.put("userId", userId);
        jsonObject.put("updateId", System.currentTimeMillis());
        jsonObject.put("rights", "EDIT");


        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);

        Assert.assertEquals("false", jsonBody.getString("success"));
        Assert.assertEquals("当前没有操作权限", jsonBody.getString("message"));
    }

    /**
     * 测试资料云盘-公共文件夹添加员工，从列表中移除员工
     */
    @Test
    public void testUpdateFileUserAuthority3() throws InterruptedException {
        GetFolderData commonFolderList = new GetFolderData();
        JSONObject folderList = commonFolderList.getCommonFolderList();
        String folderId = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        System.out.println("folderId  = " + folderId);

        JSONObject userAuthority = commonFolderList.getFileUserAuthority(folderId);
        String updateId = userAuthority.getJSONArray("result").getJSONObject(0).getString("userId");//操作账户的userId
        String userId = userAuthority.getJSONArray("result").getJSONObject(1).getString("userId");
        System.out.println("userAuthority =="+userAuthority);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("currentRight", "LOOK_DOWNLOAD");
        jsonObject.put("instId", xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("id", folderId);
        jsonObject.put("userId", userId);
        jsonObject.put("updateId", updateId);


        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);

        JSONObject userAuthority1 = commonFolderList.getFileUserAuthority(folderId);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertNotEquals(userAuthority1.getJSONArray("result").size(),userAuthority.getJSONArray("result").size());
    }
}
