package com.live.xmutils;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import io.restassured.response.Response;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static io.restassured.RestAssured.given;

public class  GetFolderData extends XMBaseTest {


    public JSONObject saveFolder() {

        dataApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_saveFolder") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeDataRequest();

        String name = "测试文件夹新增"+ RandomStringUtil.randomString(6);  //新增文件夹名称
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("createUser", "ADMIN");
        jsonObject.put("disk", "COMMON");
        jsonObject.put("folderTypeEnum", "FOLDER");
        jsonObject.put("instId", "1235115978015883266");
        jsonObject.put("name", name);
        jsonObject.put("parentId", null);

        dataApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(dataApi);
        JSONObject jsonBody = dataApi.getBodyInJSON();

        return jsonBody;
    }

    /**
     * 资料云盘-我的文件
     */
    public JSONObject getFolderList() {

        dataApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_folderList") // API 名称  必传
                .setEnv("prod")             // 运行环境   测试时可指定自己要运行的环境。 不穿默认取系统指定的允许环境
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 1);
        jsonObject.put("size", 10);
        jsonObject.put("disk", "MYSELF");


        dataApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(dataApi);
        JSONObject jsonBody = dataApi.getBodyInJSON();

        return jsonBody;
    }

    /**
     * 资料云盘-公共文件
     */
    public JSONObject getCommonFolderList() throws InterruptedException {

        dataApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_folderList") // API 名称  必传
                .setEnv("prod")             // 运行环境   测试时可指定自己要运行的环境。 不穿默认取系统指定的允许环境
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 1);
        jsonObject.put("size", 10);
        jsonObject.put("disk", "COMMON");
        jsonObject.put("folderIdType", "FOLDER");
        jsonObject.put("instId", xmAppApi.getLoginInfo().getInstId());


        dataApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(dataApi);
        JSONObject jsonBody = dataApi.getBodyInJSON();
        TimeUnit.SECONDS.sleep(3);

        return jsonBody;
    }

    /**
     * 资料云盘-公共文件-权限管理-员工列表
     */
    public JSONObject getFileUserAuthority(String folderId) {

        dataApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getFileUserAuthority") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id",folderId);
        jsonObject.put("instId", xmAppApi.getLoginInfo().getInstId());


        dataApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(dataApi);
        JSONObject jsonBody = dataApi.getBodyInJSON();

        return jsonBody;
    }


    public String getCommonFolderListFirstId(){

        dataApi.setApiModule(ApiModele.CloudClass_File)
                .setApiName("API_commonFolderList")
                .setLoginUser("zhangYuM_b")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current",1);
        jsonObject.put("disk", "COMMON");
        jsonObject.put("folderIdType", "FOLDER");
        jsonObject.put("instId",xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("searchName", null);
        jsonObject.put("size", 10);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);

        JSONObject responseRes = dataApi.getBodyInJSON();
        System.out.println(responseRes);

        String id = responseRes.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        return id;
    }
}

