package com.live.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TimeUtils{
    private static Date praseDate(String time,SimpleDateFormat sdf ) {
        try {
            return  sdf.parse(time);
        } catch (ParseException e) {
            e.printStackTrace();
            return  null;
        }
    }

    /**
    * @Description:  获取当天某一时分的时间
    * @Author: pdd
    * @Date: 2020/11/26/15:27
    */
    public static long getToDayTime(int hour,int minute){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, hour);
        calendar.set(Calendar.MINUTE, minute);
        calendar.set(Calendar.SECOND, 0);

        long  data = calendar.getTime().getTime();
        return data;
    }


    /**
     * @return 获取当天日期时间戳（0点）
     */
    public static long getTodayTime(){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);

        long  today_date = calendar.getTime().getTime();

        return today_date;
    }
    /**
     * @return 获取当天结束日期时间戳（24点）
     */
    public static long getTodayEndTime(){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);

        long  today_end_date = calendar.getTime().getTime();

        return today_end_date;
    }

    /**
     *
     * @return 获取当前时间戳
     */
    public static long getCurrentTime(){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        long  today_date = calendar.getTime().getTime();
        return today_date;
    }



    // 获取一周前的日期
    public static long getLastWeekDate()  {
        // 获取一周前的时间
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c_1 = Calendar.getInstance();
        c_1.setTime(new Date());
        c_1.add(Calendar.DATE, - 7);
        Date d = c_1.getTime();
        String lastweek_day = sdf_day.format(d) +" 00:00:00";
        Date lastweek_date = null;
        lastweek_date = praseDate(lastweek_day,sdf_hms);

        long lastweek_time = lastweek_date.getTime();


        return lastweek_time;
    }

    // 获取几天后的23：59：59
    public static long getAfterDayDate(int addDay)  {
        // 获取几天后的时间
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c_1 = Calendar.getInstance();
        c_1.setTime(new Date());
        c_1.add(Calendar.DATE, +addDay);
        Date d = c_1.getTime();
        String lastday_day = sdf_day.format(d) +" 23:59:59";
        Date lastday_date = null;
        lastday_date = praseDate(lastday_day,sdf_hms);

        long afterday_time = lastday_date.getTime();


        return afterday_time;
    }

    /**
     *   获取数月后日期时间戳
     * @param sDate 初始时间
     * @param addMonth 增加的月份数
     * @param addDay  增加的天数
     * @return
     * @throws ParseException
     */
    public static  long  getAfterMonthDate(long sDate,int addMonth, int addDay)  {
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date smdate = new Date(sDate);
        Calendar c_1 = Calendar.getInstance();
        c_1.setTime(smdate);

        //购买一个月的课程
        c_1.add(Calendar.MONTH, +addMonth);
        // 计算时需要减去最后一天时间，不记入时间计算
        c_1.add(Calendar.DATE, -1);
        // 计算赠送的天数
        c_1.add(Calendar.DATE, +addDay);

        Date lastweek_aftermonth_d = c_1.getTime();
        String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) +" 00:00:00";

        Date date_month = praseDate(lastweek_aftermonth,sdf_hms);

        long time_month = date_month.getTime();
        return  time_month;

    }


    /**
     * 获取数月前的日期
     * @param sDate 初始时间
     * @param addMonth  往前数的月份数
     * @param addDay  往前增加的天数
     * @return
     * @throws ParseException
     */
    public static  long getLastrMonthDate(long sDate,int addMonth, int addDay) {
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date smdate =new Date(sDate);
        Calendar c_1 = Calendar.getInstance();
        c_1.setTime(smdate);

        //购买一个月的课程
        c_1.add(Calendar.MONTH, -addMonth);
        // 计算赠送的天数
        c_1.add(Calendar.DATE, -addDay);
        // 计算时需要减去最后一天时间，不记入时间计算
        c_1.add(Calendar.DATE, 1);

        Date lastweek_aftermonth_d = c_1.getTime();
        String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) +" 00:00:00";
        Date date_month = praseDate(lastweek_aftermonth,sdf_hms);

        long time_month = date_month.getTime();

        return  time_month;

    }

    /**
     *
     * @return 获取当月第一天时间戳   零点零分
     * @throws ParseException
     */
    public  static long getMonthFristDay() {


        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        Calendar c = Calendar.getInstance();
        //c.add(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 1);//设置为1号,当前日期既为本月第一天

        Date lastweek_aftermonth_d = c.getTime();
        String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) + " 00:00:00";
        Date date_month = praseDate(lastweek_aftermonth,sdf_hms);

        long time_month = date_month.getTime();
        return  time_month;
    }

    /**
     *
     * @return 获取当月第一天时间戳   零点零分
     * @throws ParseException
     */
    public  static long getMonthLastDay() {
            SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            //获取当前月最后一天
            Calendar ca = Calendar.getInstance();
            ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
            Date lastweek_aftermonth_d = ca.getTime();
            String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) + " 00:00:00";
            Date date_month = praseDate(lastweek_aftermonth,sdf_hms);
            long time_month = date_month.getTime();
            return  time_month;

        }

    /**
     *
     * @return 获取当月最后一天时间戳   23：59：59
     * @throws ParseException
     */
    public  static long getMonthLastTime() {
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        //获取当前月最后一天
        Calendar ca = Calendar.getInstance();
        ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date lastweek_aftermonth_d = ca.getTime();
        String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) + " 23:59:59";
        Date date_month = praseDate(lastweek_aftermonth,sdf_hms);
        long time_month = date_month.getTime();
        return  time_month;

    }

    /**
     *
     * @return 获取当周第一天时间戳   零点零分
     * @throws ParseException
     */
    public  static String getWeekFirstTime() {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(Calendar.MONDAY);//以周一为首日
        cld.set(Calendar.HOUR_OF_DAY, 0);
        cld.set(Calendar.MINUTE, 0);
        cld.set(Calendar.SECOND, 0);
        cld.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);//周一
        String beginWeekTime = String.valueOf(cld.getTime().getTime());
        return beginWeekTime;
    }

    /**
     *
     * @return 获取当周最后一天时间戳   23：59：59
     * @throws ParseException
     */
    public  static String getWeekLastTime() {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        int week = cld.get(Calendar.DAY_OF_WEEK);
        cld.add(Calendar.DATE, 8-week);
        cld.set(Calendar.HOUR_OF_DAY, 23);
        cld.set(Calendar.MINUTE, 59);
        cld.set(Calendar.SECOND, 59);
        String endWeekTime = String.valueOf(cld.getTime().getTime());
        return endWeekTime;
    }

    /**
     *  获取两个日期之间的天数差
     * @param time_s  起始时间
     * @param time_e  结束时间
     * @return
     * @throws ParseException
     */
    public static int daysBetween(long time_s,long time_e)  {


        long between_days = (time_e - time_s) / (1000 * 3600 * 24);

        // 消耗天数，需计算当天
        int daysBetween = Integer.parseInt(String.valueOf(between_days))+1;

        return Integer.parseInt(String.valueOf(daysBetween));
    }




    public static void main1(String[] args)  {
        // 获取当天时间
        long todayDate = getTodayTime();


        long lastWeekDate = getLastWeekDate();


        // 获取当前日期前一个星期，再往后推一个月 再加两天赠送天数的 日期
        long afterMonthDate= getAfterMonthDate(lastWeekDate,1,2);


        // 获取当前日期前一个星期，再往前推一个月 再加两天赠送天数的 日期
        long lastMonthDate= getLastrMonthDate(lastWeekDate,1,2);



        // 计算上周，到上周往后推一个月后的天数差
        int lastWeekDate_afterMonthDate = daysBetween(lastWeekDate,afterMonthDate);
        // 上周 往后推一个月 的天数差，为实际购买天数 // 减去赠送的2 天




        //已消耗 7天 ，剩余天数 = 购买天数- 消耗天数
        int leftDays_1 = lastWeekDate_afterMonthDate - 7;

        // 剩余购买天数 要减去赠送天数



        int lastWeekDate_lastMonthDate= daysBetween(lastMonthDate,lastWeekDate);


        System.out.println("上周往后推一个月的日期  到上周的天数差：" + lastWeekDate_afterMonthDate);
        System.out.println("上周往前推一个月的日期  到上周的天数差：" + lastWeekDate_lastMonthDate);

        // 获取本周周一的时间
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//设置日期格式
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(Calendar.MONDAY);//以周一为首日
        cld.set(Calendar.HOUR_OF_DAY, 0);
        cld.set(Calendar.MINUTE, 0);
        cld.set(Calendar.SECOND, 0);
        cld.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);//周一
        long  Monday_date = cld.getTime().getTime();
        System.out.println("本周周一："+df.format(cld.getTime()) + " --"+Monday_date);


        cld.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);//周日
        cld.set(Calendar.HOUR_OF_DAY, 23);
        cld.set(Calendar.MINUTE, 59);
        cld.set(Calendar.SECOND, 59);
        long  Sunday_date = cld.getTime().getTime();
        System.out.println("本周周日"+df.format(cld.getTime()) + " --"+Sunday_date);

    }
    /**
     * 获取当前日期 ”yyyymmdd“
     * @return
     */
    public static String getCurrentDateString(){
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        String  today_date = sdf_day.format(calendar.getTime());
        return today_date;
    }

}
