package com.live.cases.fileManage.myselfFolder;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetFolderData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhangying on  2021/2/05
 */

public class TestMoveFolder extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_moveFolder") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 测试移动文件夹-移动到自身文件夹
     */
    @Test
    public void testMoveFolder() {

        GetFolderData getFolderData = new GetFolderData();
        JSONObject folderList = getFolderData.getFolderList();
        JSONObject folder = getFolderData.saveMyselfFolder();  //新增文件数据，以免存量数据不足导致运行报错

        String folderId = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        List moveIds = new ArrayList();
        moveIds.add(folderId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("disk","MYSELF");
        jsonObject.put("moveIds",moveIds);
        jsonObject.put("newParentId",folderId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);

        Assert.assertEquals("false", jsonBody.getString("success"));
        Assert.assertEquals("不能将文件移动到自身或其子目录下", jsonBody.getString("message"));
    }

    /**
     * 测试移动文件夹-移动到其他文件夹
     */
    @Test
    public void testMoveFolder1() {

        GetFolderData getFolderData = new GetFolderData();
        JSONObject folderList = getFolderData.getFolderList();

        String folderId = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        String folderId1 = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(1).getString("id");

        List moveIds = new ArrayList();
        moveIds.add(folderId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("disk","MYSELF");
        jsonObject.put("moveIds",moveIds);
        jsonObject.put("newParentId",folderId1);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
    }

}
