package com.live.cases.videoClass;

import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import jdk.nashorn.internal.runtime.options.LoggingOption;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;
/*
* fym
* 2021-2-6
* */


public class TestLessonScheduleListPage extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_lessonScheduleListPage") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    //默认视频课次列表
    @Test
    public void testLessonScheduleListPage(){
        Map bodyMap = new HashMap();
        bodyMap.put("current",1);
        bodyMap.put("instId",xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("size",10);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

    //按条件查询
    @Test
    public void testLessonScheduleListPageOrder(){
        Map bodyMap = new HashMap();
        bodyMap.put("current",1);
        bodyMap.put("instId",xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("size",10);
        bodyMap.put("beginTime","1612627200000");
        bodyMap.put("endTime","1612713599999");
        bodyMap.put("teacherId","1303609085537103873");
        bodyMap.put("scheduleName","小王老师视频课接口测试");


        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("1", jsonBody.getJSONObject("result").getString("total"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

}
