package com.live.cases.largeClassLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/02
 */

public  class TestGetCourseDetail extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getCourseDetail") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 查看直播课上课记录详情
     */
    @Test
    public void testGetCourseDetail() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId","1356196461296828418");
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("courseName ="+jsonBody.getJSONObject("result"));

        Assert.assertNotEquals(jsonBody.getJSONObject("result").getJSONArray("liveStudentBaseVO").size(), 0);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

}
