package com.live.cases.saasTeacher;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/3/5 4:33 下午
 */
public class TestQueryTeacherVisitData extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_queryTeacherVisitData") // API 名称  必传
                .setLoginUser("zhangy-T")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 测试资料云盘-4.0T端账号获取直播课老师上课数据
     */
    @Test(description = "4.0T端账号获取直播课老师上课数据-欢拓")
    public void testQueryTeacherVisitData() {

//        liveCourseId: "1366213480022859778"    //课程名称：非旗舰版大班直播课

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId", "1366213480022859778");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertNotNull( jsonBody.getJSONObject("result").getJSONArray("visitorInfoVOList"));
        Assert.assertNotNull( jsonBody.getJSONObject("result").getString("totalDuration"));
    }
}
