package com.live.cases.fileManage.commonFolder;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetFolderData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhangying on  2021/2/05
 */

public class TestJudgeRelation extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_judgeRelation") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 判断文件的关联关系，删除文件之前需要调用
     */
    @Test
    public void testJudgeRelation() throws InterruptedException {

        GetFolderData getFolderData = new GetFolderData();
        JSONObject folder = getFolderData.saveFolder();    //新增文件数据，以免存量数据不足导致运行报错

        JSONObject folderList = getFolderData.getCommonFolderList();

        String folderId = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");System.out.println("folderList = "+folderList);

        List folderIds = new ArrayList();
        folderIds.add(folderId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId",xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("folderIds",folderIds);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("false", jsonBody.getString("result"));    //没有关联关系
    }

}
