package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/3/18 6:09 下午
 */
public class TestLargeInteractionDelCourse extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_delCourse") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 大班互动直播课-删除未成功开课的课程
     */
    @Test(description = "大班互动直播课-删除未成功开课的课程")
    public void testGetCourseDetail() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getInteractionCourseData = getLiveCourseData.getInteractionClassLiveListWithStatus("EXPIRED");
        System.out.println("getInteractionCourseData =="+getInteractionCourseData);

        String liveCourseId = getInteractionCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId  ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        JSONObject getLargeCourseData1 = getLiveCourseData.getInteractionClassLiveListWithStatus("EXPIRED");
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        Assert.assertNotEquals(liveCourseId1, liveCourseId);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

    /**
     * 大班互动直播课-删除已完成的课程
     */
    @Test(description = "大班互动直播课-删除已完成的课程")
    public void testGetCourseDetail1() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.getInteractionClassLiveListWithStatus("FINISH");
        System.out.println("getLargeCourseData =="+getLargeCourseData);

        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId  ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        JSONObject getLargeCourseData1 = getLiveCourseData.getInteractionClassLiveListWithStatus("FINISH");
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

//        Assert.assertNotEquals("直播课已扣学员课时,不支持删除", "message");
//        Assert.assertEquals("false", jsonBody.getString("success"));
//        Assert.assertEquals(liveCourseId1, liveCourseId);
        Assert.assertEquals("true", jsonBody.getString("success"));


    }


    /**
     * 大班互动直播课-删除待上课的课程
     */
    @Test(description = "大班互动直播课-删除待上课的课程")
    public void testGetCourseDetail3() throws InterruptedException {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject createCourse = getLiveCourseData.createLargeInteractionClassLive();

        JSONObject getLargeCourseData = getLiveCourseData.getInteractionClassLiveListWithStatus("UN_START");
        System.out.println("getLargeCourseData =="+getLargeCourseData);

        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId  ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        JSONObject getLargeCourseData1 = getLiveCourseData.getInteractionClassLiveListWithStatus("FINISH");
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertNotEquals(liveCourseId1, liveCourseId);
    }

    /**
     * 大班互动直播课-删除上课中的课程
     */
    @Test(description = "大班互动直播课-删除上课中的课程")
    public void testGetCourseDetail4() throws InterruptedException {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject createCourse = getLiveCourseData.createLargeInteractionClassLive();
        String courseId =createCourse.getString("result");

        JSONObject getStartingCourse = getLiveCourseData.changeCourseStateToStarting(courseId);

        JSONObject getLargeCourseData = getLiveCourseData.getInteractionClassLiveListWithStatus("STARTING");
        System.out.println("getLargeCourseData =="+getLargeCourseData);

        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId  ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        JSONObject getLargeCourseData1 = getLiveCourseData.getInteractionClassLiveListWithStatus("STARTING");
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        JSONObject finishCourse = getLiveCourseData.changeCourseStateToFinish(liveCourseId1);

        Assert.assertEquals("false", jsonBody.getString("success"));
        Assert.assertEquals("删除课程处于上课中状态", jsonBody.getString("message"));
    }
}
