package com.live.cases.liveAssets;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveAssetsData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangying
 * @date 2021/3/19 4:54 下午
 */
public class TestExportLiveAssetsOrder extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_exportLiveAssetsOrder") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试账户管理-订单导出
     */
    @Test(description = "测试全部导出订单")
    public void testExportLiveAssetsOrder() {

        List orderStates = new ArrayList();

        List orderTypes = new ArrayList();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current","1");
        jsonObject.put("size","10");
        jsonObject.put("sort","DEFAULT");
        jsonObject.put("orderStates",orderStates);
        jsonObject.put("orderTypes",orderTypes);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertNotNull(jsonBody.getString("result"));  //result返回的是一个URL
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

    /**
     * 测试账户管理-订单导出
     */
    @Test(description = "测试查看已完成订单导出")
    public void testExportLiveAssetsOrder1() {

        List orderStates = new ArrayList();
        orderStates.add("PAY_SUCCESS");

        List orderTypes = new ArrayList();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current","1");
        jsonObject.put("size","10");
        jsonObject.put("sort","DEFAULT");
        jsonObject.put("orderStates",orderStates);
        jsonObject.put("orderTypes",orderTypes);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertNotNull(jsonBody.getString("result"));  //result返回的是一个URL
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

    /**
     * 测试账户管理-订单导出
     */
    @Test(description = "测试查看已失效订单导出")
    public void testExportLiveAssetsOrder2() {

        List orderStates = new ArrayList();
        orderStates.add("PAY_UNDO");

        List orderTypes = new ArrayList();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current","1");
        jsonObject.put("size","10");
        jsonObject.put("sort","DEFAULT");
        jsonObject.put("orderStates",orderStates);
        jsonObject.put("orderTypes",orderTypes);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertNotNull(jsonBody.getString("result"));  //result返回的是一个URL
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

    /**
     * 测试账户管理-订单导出
     */
    @Test(description = "测试查看已完成的录制扣费订单导出")
    public void testExportLiveAssetsOrder3() {

        List orderStates = new ArrayList();
        orderStates.add("PAY_SUCCESS");

        List orderTypes = new ArrayList();
        orderTypes.add("RECORD");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current","1");
        jsonObject.put("size","10");
        jsonObject.put("sort","DEFAULT");
        jsonObject.put("orderStates",orderStates);
        jsonObject.put("orderTypes",orderTypes);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertNotNull(jsonBody.getString("result"));  //result返回的是一个URL
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

    /**
     * 测试账户管理-订单导出
     */
    @Test(description = "测试查看已完成的上课扣费订单导出")
    public void testExportLiveAssetsOrder4() {

        List orderStates = new ArrayList();
        orderStates.add("PAY_SUCCESS");

        List orderTypes = new ArrayList();
        orderTypes.add("CLASS");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current","1");
        jsonObject.put("size","10");
        jsonObject.put("sort","DEFAULT");
        jsonObject.put("orderStates",orderStates);
        jsonObject.put("orderTyoes",orderTypes);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertNotNull(jsonBody.getString("result"));  //result返回的是一个URL
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }
}
