package com.live.cases.videoClass;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetVideoClassData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/8 2:53 下午
 */
public class TestEditLessonSchedule extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Video) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_editLessonSchedule") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    @Test
    public void testEditLessonSchedule(){

        String scheduleName = RandomStringUtil.randomNumber(30,"editVideoClass_");

        List studentIds = new ArrayList();
        studentIds.add("");

        Map picMap = new HashMap();
        picMap.put("size",1791124);
        picMap.put("mediaName","微信截图_20190122110413.png");
        picMap.put("mediaContent","1358261654633242626");
        picMap.put("mediaType","PICTURE");
        picMap.put("mediaUrl","https://xm-prod-resource.oss-cn-hangzhou.aliyuncs.com/inst/1301797436402806785/live/course/20210207114948/PSrKzRihxMfKGifw.png?Expires=1612854029&OSSAccessKeyId=LTAI2rWiIxxdBo0w&Signature=Oa90KZ%2Bz8Wkm8%2FrZ6FygjcAIRBU%3D");
        picMap.put("contentType","INTRO");

        Map textMap = new HashMap();
        textMap.put("mediaType","TEXT");
        textMap.put("mediaContent","<p>这是视频课简介</p>");
        textMap.put("contentType","INTRO");
        textMap.put("mediaContentLength",7);


        List scheduleMedia = new ArrayList();
        scheduleMedia.add(picMap);
        scheduleMedia.add(textMap);

        GetVideoClassData getVideoClassData = new GetVideoClassData();
        JSONObject jsonBody  = getVideoClassData.VideoClassData();
        String id = jsonBody.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");


        Map bodyMap = new HashMap();
        bodyMap.put("id",id);
        bodyMap.put("instId",xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("videoName","胖胖的你悠然自得.mp4");
        bodyMap.put("videoDuration",30);
        bodyMap.put("scheduleName",scheduleName);
        bodyMap.put("scheduleVideoId","1357973439543160834");
        bodyMap.put("joinType","ALL");
        bodyMap.put("teacherId","1303609085537103873");
        bodyMap.put("scheduleMedia",scheduleMedia);
        bodyMap.put("studentIds",studentIds);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody0 = xmAppApi.getBodyInJSON();

        JSONObject jsonObject1 = getVideoClassData.VideoClassData();


        Assert.assertEquals(scheduleName,jsonObject1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("scheduleName"));




    }



}
