package com.live.cases.fileManage.commonFolder;


import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhangying on  2020/11/19
 */

public class TestAddRelation extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("api_addRelation") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);          // 所属端位（B端，C端，M端等, 必传）
                dal.setCase_owner("zhangying");
        super.beforeTest();
    }

    /**
     * 测试课次添加关联文件
     */
    @Test
    public void testAddRelationWithHave() {
        List contentList = new ArrayList();
        contentList.add("1329253624435363842");
        System.out.println("contentList= "+contentList);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId",xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("relationId","1329252848772321283");
        jsonObject.put("relationType","SCHEDULE");
        jsonObject.put("addFolderIds",contentList);
        System.out.println("jsonObject = "+jsonObject);

        xmAppApi.doPost(okHttpClient, url, params, jsonObject.toJSONString() , headers);
        JSONObject jsonBody = okHttpClient.getBodyInJSON();

        Assert.assertEquals("false", jsonBody.getString("success"));
        Assert.assertEquals("存在已有的关联关系", jsonBody.getString("message"));

    }
}

