package com.live.cases.liveAssets;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveAssetsData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/3/19 2:59 下午
 */
public class TestOrderDetail extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_orderDetail") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试账户管理-订单详情
     */
    @Test(description = "测试查看已完成订单详情")
    public void testOrderDetail() {
        GetLiveAssetsData getLiveAssetsData = new GetLiveAssetsData();
        JSONObject getLiveAssetsOrder = getLiveAssetsData.getLiveAssetsPageList();
        System.out.println("getLiveAssetsOrder ==" + getLiveAssetsOrder);

        String orderId = getLiveAssetsOrder.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("orderId");
        System.out.println("orderId =="+ orderId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderId",orderId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals(orderId, jsonBody.getJSONObject("result").getString("orderId"));
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }
}
