package com.live.utils.pddtest;

import com.alibaba.fastjson.JSONObject;
import com.live.utils.JsonAndFile;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * @Auther: pdd
 * @Date: 2021/04/27/18:10
 * @Description:
 */
public class AddUserInfo {
    static String caseURI = "cloudclass_video_b = /src/main/resources/apicase/api-video-b.json;" +
            "cloudclass_video_c = /src/main/resources/apicase/api-video-c.json;" +
            "cloudclass_file_b = /src/main/resources/apicase/api-file-b.json;" +
            "cloudclass_file_c = /src/main/resources/apicase/api-file-c.json;" +
            "cloudclass_customerLive_api = /src/main/resources/apicase/customerLive.json;" +
            "cloudclass_apollo_api = /src/main/resources/apicase/apollo.json;" +
            "cloudclass_series_b = /src/main/resources/apicase/series-course-b.json;";

    public static void main(String[] args) {
        insetApiInfo();
        //insetApiUserInfo();
    }

    public static void insetApiInfo() {
        caseURI = caseURI.replaceAll("\\s*", ""); //可以替换大部分空白字符， 不限于空格 ；
        String[] strs = caseURI.split(";");

        ApplicationContext applicationContext = new ClassPathXmlApplicationContext("applicationContext.xml");

        JdbcTemplate jdbcTemplate = (JdbcTemplate) applicationContext.getBean("jdbcTemplate");

        List<Object[]> batchArgs = new ArrayList<>();

        String sql_1 = "SELECT count(1) from api_info WHERE api_name = ? and business_module =? and api_module = ? ";
        String sql_2 = "INSERT INTO api_info (api_name,business_module,api_module,api_path,api_contentType,api_describe,api_alias,request_parameter) VALUES(?,?,?,?,?,?,?,?)";

        Arrays.stream(strs).forEach(str -> {
            String api_module = str.substring(0, str.indexOf("="));
            String path = str.substring(str.indexOf("=") + 1);
            String fileParam = new JsonAndFile().readTxtFile(System.getProperty("user.dir") + path);
            String business_module = "live";

            JSONObject apis = JSONObject.parseObject(fileParam);
            if(null==apis){
                return;
            }
            Set<String> apiNames = apis.keySet();


            apiNames.stream().forEach(apiName -> {
                int i = jdbcTemplate.queryForObject(sql_1, new Object[]{apiName, business_module, api_module}, Integer.class);
                if (i < 1) {
                    JSONObject api = apis.getJSONObject(apiName);
                    String api_path = api.getString("apiPath");
                    String api_contentType = api.getString("apiContentType");
                    String api_alias = api.getString("apiName");
                    String api_describe = api.getString("desc");
                    String request_parameter = api.containsKey("request_parameter") ? api.getString("request_parameter") : "";
                    batchArgs.add(new Object[]{apiName, business_module, api_module, api_path, api_contentType, api_describe, api_alias, request_parameter});
                }
            });

        });


        System.out.println("size========" + batchArgs.size());
        if (batchArgs.size() > 0) {
            jdbcTemplate.batchUpdate(sql_2, batchArgs);
        }

    }

    // 补充新增账号
    public static void insetApiUserInfo() {
        ApplicationContext applicationContext = new ClassPathXmlApplicationContext("applicationContext.xml");
        JdbcTemplate jdbcTemplate = (JdbcTemplate) applicationContext.getBean("jdbcTemplate");
        String sql = "INSERT INTO user_info (user_name,inst_id,inst_name,account_no,passwd,env,uid,aid, user_type,open_id,app_id,xcx_open_id,p,xm_token,deptpath,tid) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

        List<Object[]> batchArgs = new ArrayList<>();

        String parameters = JsonAndFile.readTxtFile(System.getProperty("user.dir") + "/src/main/resources/parameter.json");
        JSONObject object = JSONObject.parseObject(parameters);
        Set<String> keySet_userName = object.keySet();

        for (String key_userName : keySet_userName) {
            String userName = key_userName;
            JSONObject json_userName = object.getJSONObject(key_userName);
            Set<String> keySet_env = json_userName.keySet();
            for (String key_env : keySet_env) {

                String env = key_env;
                JSONObject json_env = json_userName.getJSONObject(key_env);

                String sql_2 = "SELECT count(1) FROM user_info WHERE user_name = ? and env = ? ";

                int i = jdbcTemplate.queryForObject(sql_2, new Object[]{userName, env}, Integer.class);
                if (i > 0) {
                    continue;
                }


                String instId = json_env.containsKey("inst_Id") ? json_env.getString("instId") : "";
                String instName = json_env.containsKey("instName") ? json_env.getString("instName") : "";
                String account_no = json_env.containsKey("accountNo") ? json_env.getString("accountNo") : "";
                String passwd = json_env.containsKey("certificate") ? json_env.getString("certificate") : "";
                String uid = json_env.containsKey("uid") ? json_env.getString("uid") : "";
                String user_type = json_env.containsKey("userType") ? json_env.getString("userType") : "";
                String open_id = json_env.containsKey("openId") ? json_env.getString("openId") : "";
                String app_id = json_env.containsKey("appId") ? json_env.getString("appId") : "";
                String xcx_open_id = json_env.containsKey("xcxOpenId") ? json_env.getString("xcxOpenId") : "";
                String p = json_env.containsKey("p") ? json_env.getString("p") : "";
                String xm_token = json_env.containsKey("xmtoken") ? json_env.getString("xmtoken") : "";
                String deptpath = json_env.containsKey("deptpath") ? json_env.getString("deptpath") : "";
                String aid = json_env.containsKey("aid") ? json_env.getString("aid") : "";
                String tid = json_env.containsKey("tid") ? json_env.getString("tid") : "";

                batchArgs.add(new Object[]{userName, instId, instName, account_no, passwd, env, uid, aid, user_type, open_id, app_id, xcx_open_id, p, xm_token, deptpath,tid});

            }
        }
        batchArgs.size();
        jdbcTemplate.batchUpdate(sql, batchArgs);
        System.out.println("size========" + batchArgs.size());


    }
}
