package com.live.cases.fileManage.myselfFolder;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetFolderData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhangying on  2021/2/05
 */

public class TestRenameFolder extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_renameFolder") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 测试移动文件夹-重命名文件夹
     */
    @Test
    public void testRenameFolder() {

        GetFolderData getFolderData = new GetFolderData();
        JSONObject folder = getFolderData.saveMyselfFolder();    //新增文件数据，以免存量数据不足导致运行报错

        JSONObject folderList = getFolderData.getFolderList();

        String folderId = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        String folderName = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("folderName");
        System.out.println("folderList = "+folderList);

        String name = "测试文件夹重命名"+ RandomStringUtil.randomString(6);  //云盘文件名称
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name",name);
        jsonObject.put("id",folderId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);

        JSONObject folderList1 = getFolderData.getFolderList();
        String folderName1 = folderList1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("folderName");
        System.out.println("folderName1 = "+folderName1);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertNotEquals(folderName1,folderName);
    }

}
