package com.live.cases.myClassAPP;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/3/2 2:07 下午
 */
public class TestCheckAssetsBalance extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_customerLive) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_checkAssetsBalance") // API 名称  必传
                .setLoginUser("zhangy-APPC")         // http 接口，测试账号 必传
                .setTerminal(Terminal.APP_C);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("zhangying");
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试C端判断云课堂账户余额的接口
     */
//    @Test
    public void testCheckAssetsBalance() throws InterruptedException {
        GetLiveCourseData getLiveCourseData=new GetLiveCourseData();
        JSONObject largeCourse=getLiveCourseData.createLargeInteractionClassLive();

        String liveCourseId=largeCourse.getString("result");
        System.out.println("liveCourseId ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("headers =="+headers);
        System.out.println("jsonBody =="+jsonBody);

        //返回值只有这几个
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("true", jsonBody.getString("success"));
    }
}
