package com.live.cases.fileManage.commonFolder;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetFolderData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangying
 * @date 2021/2/8 3:23 下午
 */
public class TestAddFileUserAuthorityList extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_addFileUserAuthorityList") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 测试资料云盘-公共文件夹添加成员
     */
    @Test
    public void testAddFileUserAuthorityList() {
        GetFolderData commonFolderList = new GetFolderData();
        JSONObject FolderList = commonFolderList.getCommonFolderList();
        System.out.println("FolderList= " + FolderList);

        JSONObject rightsListObject = new JSONObject();
        rightsListObject.put("rights","LOOK_DOWNLOAD");
        rightsListObject.put("userId","1244920914395918338");

        List rightsList = new ArrayList();
        rightsList.add(rightsListObject);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId", "1235115978015883266");
        jsonObject.put("id", "1362659086265585665");
        jsonObject.put("createId",xmAppApi.getLoginInfo().getAid());
        jsonObject.put("disk", "COMMON");
        jsonObject.put("rightsList", rightsList);


        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);

        Assert.assertEquals("true", jsonBody.getString("success"));
    }

}
