package com.live.cases.fileManage.commonFolder;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/03
 */

public  class TestGetFileUserAuthority extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getFileUserAuthority") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 资料云盘-公共文件权限管理
     */
    @Test
    public void testGetFileUserAuthority() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id","1356887886424498177");
        jsonObject.put("instId","1235115978015883266");
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        Assert.assertEquals(jsonBody.getJSONArray("result").getJSONObject(0).getString("rights"),"EDIT");
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

}
