package com.live.cases.largeClassLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/2/23 5:04 下午
 */
public class TestLargeClassDelCourse extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_delCourse") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 大班直播课-删除课程(已完成)
     */
    @Test
    public void testLargeClassDelCourse() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.getLargeClassLiveListFinish();
        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId   =="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        JSONObject getLargeCourseData1 = getLiveCourseData.getLargeClassLiveListFinish();
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        Assert.assertNotEquals(liveCourseId1, liveCourseId);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

    /**
     * 大班直播课-删除课程(未成功开课)
     */
    @Test
    public void testLargeClassDelCourse1() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.getLargeClassLiveListExpired();
        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId   =="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        JSONObject getLargeCourseData1 = getLiveCourseData.getLargeClassLiveListExpired();
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        Assert.assertNotEquals(liveCourseId1, liveCourseId);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

    /**
     * 大班直播课-删除课程(待上课)
     */
    @Test
    public void testLargeClassDelCourse2() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.createLargeClassLive();
        String liveCourseId = getLargeCourseData.getString("result");
        System.out.println("liveCourseId   =="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        JSONObject getLargeCourseData1 = getLiveCourseData.getLargeClassLiveList();
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        Assert.assertNotEquals(liveCourseId1, liveCourseId);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

    /**
     * 大班直播课-删除课程(上课中)
     */
    @Test
    public void testLargeClassDelCourse3() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.getLargeClassLiveListStarting();
        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId   =="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        Assert.assertEquals("删除课程处于上课中状态", jsonBody.getString("message"));
        Assert.assertEquals("false", jsonBody.getString("success"));
        Assert.assertEquals("10000", jsonBody.getString("code"));

    }

}
