package com.live.cases.seriesCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.client.XMAppApi;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetSeriesCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/19 4:20 下午
 */
public class TestCreateSeries extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_createSeries") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    @Test
    public void testCreateSeries(){

        String seriesName = RandomStringUtil.randomNumber(25,"seriescourse_");


        Map mediaMap = new HashMap();
        mediaMap.put("mediaType","TEXT");
        mediaMap.put("mediaContent","这是系列课简介");
        mediaMap.put("key","sCJFBRyjFTzxcXCR");
        mediaMap.put("mediaContentLength",7);

        List scheduleMedia = new ArrayList();
        scheduleMedia.add(mediaMap);

        List enableJoinStuIds = new ArrayList();



        List joinStudentIds = new ArrayList();


        Map bodyMap = new HashMap();
        bodyMap.put("seriesName",seriesName);
        bodyMap.put("instId", xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("teacherId",xmAppApi.getLoginInfo().getTid());
        bodyMap.put("coverId","1362677307414863873");
        bodyMap.put("joinType","ALL");
        bodyMap.put("smsCheck","VALID");
        bodyMap.put("showType","LOCK");
        bodyMap.put("scheduleMedia",scheduleMedia);
        bodyMap.put("joinStudentIds",joinStudentIds);
        bodyMap.put("enableJoinStuIds",enableJoinStuIds);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody = xmAppApi.getBodyInJSON();

        GetSeriesCourseData getSeriesCourseData = new GetSeriesCourseData();
        JSONObject jsonObject1 = getSeriesCourseData.getSeriesPage();
//        System.out.println("jsonObject1"+jsonBody1);

        String id = jsonObject1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        Assert.assertEquals(id,jsonBody.getString("result"));



    }
}
