package com.live.cases.musicPlay;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetOnlyOneClassLiveListData;
import com.live.xmutils.GetOnlyOneCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2021/1/30
 */

public class TestDelOnlyOneClassLive extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_delCourse") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试删除乐器陪练课-课程"zy乐器陪练课1"
     */
    @Test
    public void testDelOnlyOneClassLive() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId","1357508872072433666");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("直播课已扣学员课时,不支持删除", jsonBody.getString("message"));

    }


    /**
     * 测试删除乐器陪练课-删除未成功开课的课程
     */
    @Test
    public void testDelOnlyOneClassLive1() {
        GetOnlyOneCourseData getOnlyOneCourseData=new GetOnlyOneCourseData();
        JSONObject onlyOneClassCourse = getOnlyOneCourseData.getOnlyOneCourseList();

        String liveCourseId = onlyOneClassCourse.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        String courseName = onlyOneClassCourse.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("courseName");
        System.out.println("courseName ="+courseName);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);

        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        GetOnlyOneCourseData getOnlyOneCourseData1=new GetOnlyOneCourseData();
        JSONObject onlyOneClassCourse1 = getOnlyOneCourseData1.getOnlyOneCourseList();
        String courseName1 = onlyOneClassCourse1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("courseName");

        System.out.println("courseName1 ="+courseName1);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertNotEquals(courseName, courseName1);

    }


}
