package com.live.cases.liveClientT.cloundClass;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.xmutils.GetLiveCourseData;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/11/27
 */

public class TestChangeCourseState extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("api_changeCourseState") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试改变直播课次状态-大班直播-开始直播
     */
    @Test
    public void testChangeCourseState() throws InterruptedException {
        GetLiveCourseData getLiveCourseData=new GetLiveCourseData();
        JSONObject largeCourse=getLiveCourseData.createLargeClassLive();

        String liveCourseId=largeCourse.getString("result");
        System.out.println("liveCourseId ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("courseState","STARTING");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        JSONObject classLiveList = getLiveCourseData.getLargeClassLiveList();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals("STARTING", classLiveList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("courseState"));
        Assert.assertEquals(liveCourseId,classLiveList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId"));

    }

    /**
     * 测试改变直播课次状态-结束直播
     */
    @Test(description = "修改课程状态为结束")
    public void testChangeCourseState1() {
        GetLiveCourseData getLiveCourseData=new GetLiveCourseData();
        JSONObject getInteractionCourseData = getLiveCourseData.getLargeClassLiveList();
        System.out.println(" ************"+getInteractionCourseData.getJSONObject("result"));
        String liveCourseId = getInteractionCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("courseState","FINISH");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        JSONObject classLiveList = getLiveCourseData.getLargeClassLiveList();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals("FINISH", classLiveList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("courseState"));
//        Assert.assertEquals(liveCourseId,classLiveList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId"));

    }

    /**
     * 测试改变直播课次状态-大班互动-开始直播
     */
    @Test
    public void testChangeCourseState2() throws InterruptedException {
        GetLiveCourseData getLiveCourseData=new GetLiveCourseData();
        JSONObject largeCourse=getLiveCourseData.createLargeInteractionClassLive();

        String liveCourseId=largeCourse.getString("result");
        System.out.println("liveCourseId ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("courseState","STARTING");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        JSONObject classLiveList = getLiveCourseData.getInteractionClassLiveListWithStatus("STARTING");

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals("STARTING", classLiveList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("courseState"));
        Assert.assertEquals(liveCourseId,classLiveList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId"));

    }

    /**
     * 测试改变直播课次状态-结束直播
     */
    @Test(description = "修改课程状态为结束")
    public void testChangeCourseState3() {
        GetLiveCourseData getLiveCourseData=new GetLiveCourseData();
        JSONObject getInteractionCourseData = getLiveCourseData.getInteractionClassLiveListWithStatus("STARTING");
        System.out.println(" ************"+getInteractionCourseData.getJSONObject("result"));
        String liveCourseId = getInteractionCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("courseState","FINISH");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        JSONObject classLiveList = getLiveCourseData.getInteractionClassLiveListWithStatus("FINISH");

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals("FINISH", classLiveList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("courseState"));
//        Assert.assertEquals(liveCourseId,classLiveList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId"));

    }


}
