/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomai.client;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class OkHttpClient {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static okhttp3.OkHttpClient okHttpClient;
    public static Logger logger;
    Response response;
    int responseCode;
    JSONObject responseBody;
    HashMap<String, String> responseHeadsMap;
    RequestBody requestBody;
    Request request;
    Headers.Builder headerBuilder;
    String responseStr;
    Headers responseHeaderes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPostRequest(String url, String json, Map<String, String> headers) {
        try {
            this.requestBody = RequestBody.create((MediaType)JSON, (String)json);
            this.headerBuilder = new Headers.Builder();
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    this.headerBuilder.add(entry.getKey(), entry.getValue());
                }
            }
            this.request = new Request.Builder().url(url).post(this.requestBody).headers(this.headerBuilder.build()).build();
            this.response = okHttpClient.newCall(this.request).execute();
            this.responseCode = this.response.code();
            this.responseHeaderes = this.response.headers();
            this.responseStr = this.response.body().string();
            return;
        }
        catch (Exception e) {
            logger.error("okhttp3 \u6267\u884c doPostRequest \u5f02\u5e38 >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return;
        }
        finally {
            try {
                if (this.response == null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                logger.error("okhttp3 \u6267\u884c doPostRequest \u5f02\u5e38  >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPostRequest(String url, IdentityHashMap<String, String> params, Map<String, String> headers) {
        FormBody.Builder FormBodyBuilder = new FormBody.Builder();
        if (params != null && params.keySet().size() > 0) {
            for (String key : params.keySet()) {
                FormBodyBuilder.add(key, String.valueOf(params.get(key)));
            }
        }
        this.headerBuilder = new Headers.Builder();
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.headerBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        this.request = new Request.Builder().url(url).post((RequestBody)FormBodyBuilder.build()).headers(this.headerBuilder.build()).build();
        try {
            this.response = okHttpClient.newCall(this.request).execute();
            this.responseCode = this.response.code();
            this.responseHeaderes = this.response.headers();
            this.responseStr = this.response.body().string();
            int status = this.response.code();
            Assert.assertEquals((int)status, (int)200);
        }
        catch (Exception e) {
            logger.error("okhttp3 \u6267\u884c\u5931\u8d25 >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            if (this.response != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPostForForm(String url, IdentityHashMap<String, String> paramsMap, Map<String, String> headers) {
        FormBody.Builder FormBodyBuilder = new FormBody.Builder();
        if (paramsMap != null && paramsMap.keySet().size() > 0) {
            for (String key : paramsMap.keySet()) {
                FormBodyBuilder.add(key, String.valueOf(paramsMap.get(key)));
            }
        }
        this.headerBuilder = new Headers.Builder();
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.headerBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        this.request = new Request.Builder().url(url).post((RequestBody)FormBodyBuilder.build()).headers(this.headerBuilder.build()).addHeader("contentType", "application/x-www-form-urlencoded; charset=UTF-8").build();
        try {
            this.response = okHttpClient.newCall(this.request).execute();
            this.responseCode = this.response.code();
            this.responseHeaderes = this.response.headers();
            this.responseStr = this.response.body().string();
        }
        catch (Exception e) {
            logger.error("okhttp3 post error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            if (this.response != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetRequest(String url, IdentityHashMap<String, String> queries, Map<String, String> headerParamsMap) {
        StringBuffer sb = new StringBuffer(url);
        if (queries != null && queries.keySet().size() > 0) {
            boolean firstFlag = true;
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                if (firstFlag) {
                    sb.append("?" + entry.getKey() + "=" + entry.getValue());
                    firstFlag = false;
                    continue;
                }
                sb.append("&" + entry.getKey() + "=" + entry.getValue());
            }
        }
        Headers.Builder headerBuilder = new Headers.Builder();
        if (headerParamsMap != null && headerParamsMap.size() > 0) {
            for (Map.Entry<String, String> entry : headerParamsMap.entrySet()) {
                headerBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        this.request = new Request.Builder().url(sb.toString()).headers(headerBuilder.build()).build();
        try {
            this.response = okHttpClient.newCall(this.request).execute();
            this.responseCode = this.response.code();
            this.responseHeaderes = this.response.headers();
            this.responseStr = this.response.toString();
        }
        catch (Exception e) {
            logger.error("okhttp3 put error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            if (this.response != null) {
                // empty if block
            }
        }
    }

    public JSONObject getBodyInJSON() {
        if (this.responseStr != null) {
            try {
                this.responseBody = JSONObject.parseObject((String)this.responseStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("===============================================\n");
            System.out.println("This is your response body ==> \n" + this.responseBody);
            System.out.println("===============================================\n\n");
        } else {
            this.responseBody = null;
        }
        return this.responseBody;
    }

    public String getBody() {
        System.out.println("===============================================\n");
        System.out.println("This is your response body ==> \n" + this.responseStr);
        System.out.println("===============================================\n\n");
        return this.responseStr;
    }

    public HashMap<String, String> getHeaders() {
        this.responseHeadsMap = new HashMap();
        if (null != this.responseHeaderes) {
            Set names = this.responseHeaderes.names();
            for (String name : names) {
                this.responseHeadsMap.put(name, this.responseHeaderes.get(name));
            }
        }
        return this.responseHeadsMap;
    }

    public int getResponseCode() {
        System.out.println("===============================================\n");
        System.out.println("This is your response code ==> \n" + this.responseCode);
        System.out.println("===============================================\n\n");
        return this.responseCode;
    }

    static {
        logger = LoggerFactory.getLogger(OkHttpClient.class);
        okHttpClient = new OkHttpClient.Builder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        }).build();
    }
}

