package com.live.cases.liveClientT.cloundClass;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author NHX-->zym
 * @Function B端查询课程奖杯
 * @Date 2020/11/19 15:01
 */
public class TestQueryCourseTrophy_B extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块
                .setApiName("API_queryCourseTrophy") // API 名称
                .setLoginUser("zhangYuM_b")         // http 接口，测试账号
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        dal.setCase_owner("zym")
                .setCase_name("B端查询课程奖杯：" + Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);

        super.beforeTest();
    }

    @Test(description = "B端查询课程奖杯")
    public void testQueryCourseTrophy(){

        Map<String,Object> bodyMap = new HashMap<>();
        bodyMap.put("liveCourseId","1331156473166794754");

        JSONObject jsonBody = new JSONObject(bodyMap);
        String data = jsonBody.toJSONString();

        System.out.println("请求参数==========="+data);
        //headers.put("userId","1145612151844098049");

        xmAppApi.doRequest(RequestType.JSON, params, data, headers);
        JSONObject jsonResponseBody = xmAppApi.getBodyInJSON();
        Assert.assertEquals(jsonResponseBody.getString("success"), "true", "操作成功!");


    }

}
