package com.live.cases.myClassAPP;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import java.util.HashMap;
import java.util.Map;

/**
 * @author NHX-->zhangying
 * @Function C端获取学生信息列表
 * @Date 2020/11/19 15:01
 */
public class TestGetStudentInstLinkageList_C extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_customerLive) // API 所属模块
                .setApiName("API_getStudentInstLinkageList") // API 名称
                .setLoginUser("zhangy-APPC")         // http 接口，测试账号
                .setTerminal(Terminal.APP_C);             // 所属端位（B端，C端，M端等, 必传）

        dal.setCase_owner("NHX")
                .setCase_name("C端获取学生信息列表：" + Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);

        super.beforeTest();
    }

    @Test(description = "学员和机构的联动关联关系，过滤没权限的机构")
    public void testGetStudentInstLinkageList(){

        Map<String,Object> bodyMap = new HashMap<>();

        JSONObject jsonBody = new JSONObject(bodyMap);
        String data = jsonBody.toJSONString();

        System.out.println("请求参数==========="+data);
        // "exception": "java.lang.IllegalArgumentException: userId不能为空； headers加userId
//        headers.put("userId","1145612151844098049");

        xmAppApi.doRequest(RequestType.JSON, params, data, headers);
        JSONObject jsonResponseBody = xmAppApi.getBodyInJSON();
        Assert.assertEquals(jsonResponseBody.getString("success"), "true", "操作成功!");


    }

}
